---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-HTTP Bearer認証

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **bearerFormatの反映**：OpenAPIスキーマへの反映確認
  2. **HTTP 403エラーケース**：スキーム不一致時の挙動確認
  3. **クレデンシャル空チェック**：空文字列の扱い確認

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/security/http.py` HTTPAuthorizationCredentialsクラス定義（29-66行目）
- E-02: `fastapi/security/http.py` HTTPBearerクラス定義（224-319行目）
- E-03: `fastapi/openapi/models.py` HTTPBearerモデル定義（353-356行目）
- E-04: `fastapi/security/utils.py` get_authorization_scheme_param関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTPAuthorizationCredentialsはschemeとcredentialsフィールドを持つ | E-01（63-65行目） | ○ |
| C-02 | HTTPAuthorizationCredentialsはBaseModelを継承 | E-01（29行目） | ○ |
| C-03 | auto_errorのデフォルト値はTrue | E-02（279-295行目） | ○ |
| C-04 | bearerFormatパラメータでトークンフォーマットを指定可能 | E-02（263-272行目） | ○ |
| C-05 | HTTPBearerModelを使用してOpenAPIスキームを定義 | E-02（297-300行目） | ○ |
| C-06 | スキームはbearer（大文字小文字区別なし）で検証 | E-02（313行目） | ○ |
| C-07 | スキーム不一致時にHTTPException 403を発生 | E-02（313-314行目） | ○ |
| C-08 | クレデンシャルが空の場合にHTTPException 401を発生 | E-02（315-318行目） | ○ |
| C-09 | HTTPAuthorizationCredentialsオブジェクトを返却 | E-02（319行目） | ○ |
| C-10 | auto_error=Falseの場合はNoneを返す | E-02（314, 318行目） | ○ |
| C-11 | WWW-Authenticate: Bearerヘッダーを含める | E-02（302-308行目） | ○ |
| C-12 | bearerFormatはOpenAPIドキュメントに反映される | E-03（355行目） | ○ |
| C-13 | scheme: Literal["bearer"] = "bearer"で固定 | E-03（354行目） | ○ |
| C-14 | SecurityBaseを継承している | E-02（224行目、HTTPBaseを継承） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張に根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 入力パラメータ仕様
- 0: 低リスク - 出力データ構造
- 1: 中リスク - HTTP 403とHTTP 401の使い分けの妥当性

## 6) レビュアーチェックリスト（最小）
- [ ] HTTPAuthorizationCredentialsのフィールド定義を確認
- [ ] Bearerスキームの検証が大文字小文字を区別しないか確認
- [ ] スキーム不一致時のHTTP 403レスポンスを確認
- [ ] クレデンシャル空時のHTTP 401レスポンスを確認
- [ ] bearerFormatのOpenAPIスキーマへの反映を確認
